<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Global extends Model 
{

    protected $table = 'globals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'desc', 'phone', 'website', 'country_id');

    public function photos()
    {
        return $this->morphMany('Photo');
    }

}